/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.GIOP.LocateReplyHeader;
import com.visigenic.vbroker.GIOP.LocateRequestHeader;
import com.visigenic.vbroker.GIOP.LocateStatusType;
import com.visigenic.vbroker.GIOP.ReplyHeader;
import com.visigenic.vbroker.GIOP.ReplyHeaderHelper;
import com.visigenic.vbroker.GIOP.ReplyHeaderHolder;
import com.visigenic.vbroker.GIOP.ReplyStatusType;
import com.visigenic.vbroker.GIOP.RequestHeader;
import com.visigenic.vbroker.IOP.IOR;
import com.visigenic.vbroker.IOP.IORHelper;
import com.visigenic.vbroker.IOP.IORHolder;
import com.visigenic.vbroker.IOP.ServiceContext;
import com.visigenic.vbroker.IOP.TaggedProfile;
import com.visigenic.vbroker.interceptor.Closure;
import com.visigenic.vbroker.interceptor.ServerInterceptor;
import com.visigenic.vbroker.interceptor.ServerInterceptorPackage.ShutdownReason;
import com.visigenic.vbroker.interceptor.UserException;
import com.visigenic.vbroker.orb.Adapter;
import com.visigenic.vbroker.orb.Connection;
import com.visigenic.vbroker.orb.DynamicImplementationDispatcher;
import com.visigenic.vbroker.orb.GiopConnection;
import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopMessage;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.GiopProtocol;
import com.visigenic.vbroker.orb.KeyId;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.ObjectId;
import com.visigenic.vbroker.orb.ProtocolAdapter;
import com.visigenic.vbroker.orb.ProtocolHandler;
import com.visigenic.vbroker.orb.Registrar;
import com.visigenic.vbroker.orb.SE;
import com.visigenic.vbroker.orb.ServerThreadInfo;
import com.visigenic.vbroker.orb.SkeletonDelegate;
import com.visigenic.vbroker.orb.StubDelegate;
import com.visigenic.vbroker.orb.ThreadLocal;
import com.visigenic.vbroker.orb.TransientId;
import java.io.Closeable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.ObjectHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Skeleton;

public class GiopProtocolAdapter
implements ProtocolAdapter,
Registrar {
    protected ORB _orb;
    protected GiopConnection _connection;
    protected Adapter _adapter;
    protected GiopProtocol _protocol;
    protected ProtocolHandler _protocolHandler;
    private byte[] _objectKey = EMPTY_OBJECT_KEY;
    private Skeleton _skeleton;
    private boolean _shutdownCalled = false;
    protected ServerInterceptor _interceptor;
    private static final byte[] EMPTY_OBJECT_KEY = new byte[0];
    protected static final ServiceContext[] EMPTY_SERVICE_CONTEXT = new ServiceContext[0];

    public GiopProtocolAdapter(ORB oRB, Adapter adapter, GiopProtocol giopProtocol) {
        this._orb = oRB;
        this._adapter = adapter;
        this._protocol = giopProtocol;
        this._orb.adapterManager().addRegistrar(this);
    }

    public void registerSkeleton(Skeleton skeleton) {
    }

    public synchronized void unregisterSkeleton(Skeleton skeleton) {
        if (this._skeleton == skeleton) {
            this._skeleton = null;
            this._objectKey = EMPTY_OBJECT_KEY;
        }
    }

    public void initialize(Connection connection) {
        this._connection = this._protocol.giopConnectionFactory().create(connection);
        TaggedProfile taggedProfile = connection.getPeerProfile();
        this._interceptor = this._orb.serverInterceptorFactory().create(taggedProfile);
        Class clazz = this._orb.protocolHandler();
        if (clazz != null) {
            try {
                this._protocolHandler = (ProtocolHandler)clazz.newInstance();
                this._protocolHandler.init(this._orb);
                this._connection.setProtocolHandler(this._protocolHandler);
            }
            catch (Exception exception) {
                throw new INTERNAL(exception.getMessage());
            }
        }
        if (this._orb.debug) {
            this._orb.println("New connection: " + this);
        }
    }

    protected synchronized Object getObject(byte[] byArray) {
        boolean bl = false;
        if (byArray.length == this._objectKey.length) {
            bl = true;
            int n = this._objectKey.length - 1;
            while (n >= 0) {
                if (byArray[n] != this._objectKey[n]) {
                    bl = false;
                    break;
                }
                --n;
            }
        }
        if (!bl) {
            ObjectId objectId = this._orb.toObjectId(byArray);
            if (objectId == null) {
                return null;
            }
            this._objectKey = byArray;
            this._skeleton = this._adapter.getSkeleton(objectId);
        }
        return this._skeleton;
    }

    protected void doLocateRequest(GiopMessage giopMessage) {
        java.lang.Object object;
        IOR iOR;
        LocateReplyHeader locateReplyHeader;
        block16: {
            LocateRequestHeader locateRequestHeader = (LocateRequestHeader)giopMessage.operationHeader();
            if (this._orb.debug) {
                this._orb.println("Read: " + locateRequestHeader);
            }
            locateReplyHeader = new LocateReplyHeader();
            locateReplyHeader.request_id = locateRequestHeader.request_id;
            iOR = null;
            Closure closure = null;
            if (this._interceptor != null) {
                closure = new Closure();
                iOR = this._interceptor.locate(locateRequestHeader.request_id, locateRequestHeader.object_key, closure);
                locateReplyHeader.locate_status = LocateStatusType.OBJECT_FORWARD;
            }
            if (iOR == null) {
                try {
                    Skeleton skeleton;
                    object = this._orb.toObjectId(locateRequestHeader.object_key);
                    if (this._orb.debug) {
                        this._orb.println("Read: " + object);
                    }
                    if ((skeleton = this._adapter.getSkeleton((ObjectId)object)) == null) {
                        locateReplyHeader.locate_status = LocateStatusType.UNKNOWN_OBJECT;
                        if (this._interceptor != null && (iOR = this._interceptor.locate_failed(locateRequestHeader.request_id, locateRequestHeader.object_key, closure)) != null) {
                            locateReplyHeader.locate_status = LocateStatusType.OBJECT_FORWARD;
                        }
                    } else if (object instanceof KeyId && !(object instanceof TransientId)) {
                        locateReplyHeader.locate_status = LocateStatusType.OBJECT_HERE;
                        if (this._interceptor != null) {
                            this._interceptor.locate_succeeded(locateRequestHeader.request_id, closure);
                        }
                    } else {
                        locateReplyHeader.locate_status = LocateStatusType.OBJECT_FORWARD;
                        iOR = this._adapter.keyIor(skeleton);
                        if (this._interceptor != null) {
                            IORHolder iORHolder = new IORHolder(iOR);
                            this._interceptor.locate_forwarded(locateRequestHeader.request_id, iORHolder, closure);
                            iOR = iORHolder.value;
                        }
                    }
                }
                catch (SystemException systemException) {
                    locateReplyHeader.locate_status = LocateStatusType.UNKNOWN_OBJECT;
                    if (this._interceptor == null || (iOR = this._interceptor.locate_failed(locateRequestHeader.request_id, locateRequestHeader.object_key, closure)) == null) break block16;
                    locateReplyHeader.locate_status = LocateStatusType.OBJECT_FORWARD;
                }
            }
        }
        if (this._orb.debug) {
            this._orb.println("Write: " + locateReplyHeader);
        }
        object = this._connection.createLocateReply(locateReplyHeader, false);
        if (locateReplyHeader.locate_status == LocateStatusType.OBJECT_FORWARD) {
            IORHelper.write((OutputStream)object, iOR);
            if (this._orb.debug) {
                this._orb.println("Write: " + iOR);
            }
        }
        this._connection.send_message((GiopOutputStream)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRequest(GiopMessage giopMessage, ServerThreadInfo serverThreadInfo) {
        RequestHeader requestHeader = (RequestHeader)giopMessage.operationHeader();
        if (this._orb.debug) {
            this._orb.println("Read: " + requestHeader);
        }
        GiopInputStream giopInputStream = giopMessage.buffer();
        boolean bl = giopInputStream.byteOrder();
        Closure closure = null;
        Object object = null;
        ReplyHeader replyHeader = new ReplyHeader(EMPTY_SERVICE_CONTEXT, requestHeader.request_id, ReplyStatusType.NO_EXCEPTION);
        GiopOutputStream giopOutputStream = null;
        int n = 0;
        try {
            block28: {
                block26: {
                    block27: {
                        try {
                            int n2;
                            java.lang.Object object2;
                            java.lang.Object object3;
                            serverThreadInfo.principal = requestHeader.requesting_principal;
                            serverThreadInfo.connection = this._connection.connection();
                            serverThreadInfo.adapter = this._adapter;
                            serverThreadInfo.target = object = this.getObject(requestHeader.object_key);
                            if (object instanceof DynamicImplementationDispatcher) {
                                serverThreadInfo.target = ((DynamicImplementationDispatcher)object).getObject();
                            }
                            if (this._interceptor != null) {
                                closure = new Closure();
                                object3 = new ObjectHolder(serverThreadInfo.target);
                                object2 = null;
                                n2 = giopInputStream.dataOffset();
                                giopInputStream.offset(giopInputStream.length());
                                object2 = this._interceptor.receive_request(requestHeader, (ObjectHolder)object3, giopInputStream, closure);
                                if (object2 != null) {
                                    if (!(object2 instanceof GiopInputStream)) {
                                        throw new INTERNAL("Invalid input stream: " + object2);
                                    }
                                    giopInputStream = (GiopInputStream)object2;
                                }
                                giopInputStream.offset(n2);
                                if (serverThreadInfo.target != ((ObjectHolder)object3).value) {
                                    if (!(((ObjectHolder)object3).value instanceof Skeleton)) {
                                        throw new OBJECT_NOT_EXIST();
                                    }
                                    serverThreadInfo.target = object = ((ObjectHolder)object3).value;
                                }
                                if (object == null) {
                                    throw new OBJECT_NOT_EXIST();
                                }
                                if (!this._orb.getDelegate(object).is_local(object)) {
                                    if (requestHeader.response_expected) {
                                        replyHeader.reply_status = ReplyStatusType.LOCATION_FORWARD;
                                        StubDelegate stubDelegate = (StubDelegate)this._orb.getDelegate(object);
                                        giopOutputStream = this._connection.createReply(replyHeader, bl);
                                        n = giopOutputStream.offset();
                                        IORHelper.write(giopOutputStream, stubDelegate.ior(object));
                                        this.prepareAndSendReply(requestHeader, replyHeader, object, giopOutputStream, n, closure);
                                    }
                                    java.lang.Object var12_19 = null;
                                    if (this._interceptor == null) break block26;
                                    break block27;
                                }
                            }
                            if (object == null) throw new OBJECT_NOT_EXIST();
                            if (!(object instanceof Skeleton)) {
                                throw new OBJECT_NOT_EXIST();
                            }
                            try {
                                if (this._orb.debug) {
                                    this._orb.println("Skeleton: " + object);
                                }
                                object3 = (SkeletonDelegate)this._orb.getDelegate(object);
                                giopOutputStream = this._connection.createReply(replyHeader, bl);
                                n = giopOutputStream.offset();
                                giopOutputStream.request(requestHeader);
                                boolean bl2 = ((SkeletonDelegate)object3).execute((Skeleton)object, requestHeader, giopInputStream, giopOutputStream);
                                if (giopOutputStream.byteOrder() != bl) {
                                    n2 = giopOutputStream.offset();
                                    giopOutputStream.offset(6);
                                    giopOutputStream.write_octet((byte)(giopOutputStream.byteOrder() ? 1 : 0));
                                    giopOutputStream.offset(12);
                                    ReplyHeaderHelper.write(giopOutputStream, replyHeader);
                                    giopOutputStream.offset(n2);
                                }
                                if (bl2) {
                                    replyHeader.reply_status = ReplyStatusType.USER_EXCEPTION;
                                }
                                break block28;
                            }
                            catch (SystemException systemException) {
                                throw systemException;
                            }
                            catch (Throwable throwable) {
                                object2 = new UNKNOWN("Exception: " + throwable);
                                if (this._orb.warn <= 0) throw object2;
                                this._orb.printStream().println("VisiBroker for Java runtime caught exception:");
                                throwable.printStackTrace(this._orb.printStream());
                                throw object2;
                            }
                        }
                        catch (SystemException systemException) {
                            if (this._orb.warn > 1) {
                                this._orb.println("Sending exception to client: " + systemException);
                                systemException.printStackTrace(this._orb.printStream());
                            }
                            replyHeader.reply_status = ReplyStatusType.SYSTEM_EXCEPTION;
                            if (giopOutputStream == null) {
                                giopOutputStream = this._connection.createReply(replyHeader, bl);
                                n = giopOutputStream.offset();
                            }
                            giopOutputStream.offset(n);
                            SE.write(giopOutputStream, systemException);
                            break block28;
                        }
                    }
                    this._interceptor.request_completed(requestHeader, serverThreadInfo.target, closure);
                }
                serverThreadInfo.target = null;
                serverThreadInfo.principal = null;
                serverThreadInfo.connection = null;
                serverThreadInfo.adapter = null;
                return;
            }
            if (requestHeader.response_expected) {
                this.prepareAndSendReply(requestHeader, replyHeader, serverThreadInfo.target, giopOutputStream, n, closure);
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var12_21 = null;
            if (this._interceptor != null) {
                this._interceptor.request_completed(requestHeader, serverThreadInfo.target, closure);
            }
            serverThreadInfo.target = null;
            serverThreadInfo.principal = null;
            serverThreadInfo.connection = null;
            serverThreadInfo.adapter = null;
            throw throwable;
        }
        java.lang.Object var12_20 = null;
        if (this._interceptor != null) {
            this._interceptor.request_completed(requestHeader, serverThreadInfo.target, closure);
        }
        serverThreadInfo.target = null;
        serverThreadInfo.principal = null;
        serverThreadInfo.connection = null;
        serverThreadInfo.adapter = null;
    }

    protected void prepareAndSendReply(RequestHeader requestHeader, ReplyHeader replyHeader, Object object, GiopOutputStream giopOutputStream, int n, Closure closure) {
        Environment environment;
        if (this._interceptor != null) {
            Closeable closeable;
            java.lang.Object object2;
            ReplyHeaderHolder replyHeaderHolder = new ReplyHeaderHolder(replyHeader);
            this._interceptor.prepare_reply(requestHeader, replyHeaderHolder, object, closure);
            if (replyHeader.reply_status == ReplyStatusType.USER_EXCEPTION || replyHeader.reply_status == ReplyStatusType.SYSTEM_EXCEPTION) {
                int n2 = giopOutputStream.offset();
                giopOutputStream.offset(12);
                ReplyHeaderHelper.write(giopOutputStream, replyHeader);
                giopOutputStream.offset(n2);
            }
            environment = this._orb.create_environment();
            if (replyHeader.reply_status == ReplyStatusType.USER_EXCEPTION) {
                object2 = new UserException();
                closeable = (GiopInputStream)giopOutputStream.create_input_stream();
                closeable.offset(n);
                ((UserException)object2).repository_id = closeable.read_string();
                closeable.offset(n);
                ((UserException)object2).exception_data = closeable;
                environment.exception((Exception)object2);
            } else if (replyHeader.reply_status == ReplyStatusType.SYSTEM_EXCEPTION) {
                object2 = (GiopInputStream)giopOutputStream.create_input_stream();
                ((GiopInputStream)object2).offset(n);
                environment.exception(SE.read((InputStream)object2));
            }
            int n3 = giopOutputStream.offset();
            closeable = this._interceptor.send_reply(requestHeader, replyHeader, object, giopOutputStream, environment, closure);
            if (closeable != null) {
                if (!(closeable instanceof GiopOutputStream)) {
                    throw new INTERNAL("Invalid output stream: " + closeable);
                }
                giopOutputStream = (GiopOutputStream)closeable;
                giopOutputStream.request(requestHeader);
            } else {
                giopOutputStream.offset(n3);
            }
        } else if (replyHeader.reply_status == ReplyStatusType.USER_EXCEPTION || replyHeader.reply_status == ReplyStatusType.SYSTEM_EXCEPTION) {
            int n4 = giopOutputStream.offset();
            giopOutputStream.offset(12);
            ReplyHeaderHelper.write(giopOutputStream, replyHeader);
            giopOutputStream.offset(n4);
        }
        try {
            this._connection.send_message(giopOutputStream);
            return;
        }
        catch (SystemException systemException) {
            if (this._interceptor != null) {
                environment = this._orb.create_environment();
                environment.exception(systemException);
                this._interceptor.send_reply_failed(requestHeader, replyHeader, object, environment, closure);
            }
            throw systemException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatchMessage(java.lang.Object object, ThreadLocal threadLocal) {
        GiopMessage giopMessage;
        block11: {
            ServerThreadInfo serverThreadInfo = (ServerThreadInfo)threadLocal;
            giopMessage = (GiopMessage)object;
            try {
                try {
                    switch (giopMessage.header().message_type) {
                        case 0: {
                            this.doRequest(giopMessage, serverThreadInfo);
                            java.lang.Object var6_5 = null;
                            giopMessage.release();
                            return;
                        }
                        case 3: {
                            this.doLocateRequest(giopMessage);
                            break;
                        }
                        case 2: {
                            break block11;
                        }
                        default: {
                            throw new MARSHAL("Invalid message type: " + this._orb.messageType(giopMessage.header()));
                        }
                    }
                }
                catch (Exception exception) {
                    if (this._orb.debug) {
                        exception.printStackTrace(this._orb.printStream());
                        this._orb.println("GiopProtocolAdapter: exception during dispatch: " + exception);
                    }
                    java.lang.Object var6_8 = null;
                    giopMessage.release();
                    return;
                }
            }
            catch (Throwable throwable) {
                java.lang.Object var6_9 = null;
                giopMessage.release();
                throw throwable;
            }
            java.lang.Object var6_6 = null;
            giopMessage.release();
            return;
        }
        java.lang.Object var6_7 = null;
        giopMessage.release();
    }

    private synchronized void callShutdown(ShutdownReason shutdownReason) {
        if (this._interceptor == null || this._shutdownCalled) {
            return;
        }
        ServerThreadInfo serverThreadInfo = ServerThreadInfo.instance(this._orb);
        serverThreadInfo.target = null;
        serverThreadInfo.principal = null;
        serverThreadInfo.connection = this._connection.connection();
        serverThreadInfo.adapter = this._adapter;
        this._interceptor.shutdown(shutdownReason);
        serverThreadInfo.connection = null;
        serverThreadInfo.adapter = null;
        this._shutdownCalled = true;
    }

    public java.lang.Object readMessage(ThreadLocal threadLocal) {
        try {
            return this._connection.receive_message();
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            if (this._orb.debug) {
                this._orb.println("Client aborted connection: " + this);
            }
            if (this._protocolHandler == null || !this._protocolHandler.used()) {
                this.callShutdown(ShutdownReason.CLIENT_ABORTED);
            }
            throw cOMM_FAILURE;
        }
    }

    public void destroy() {
        try {
            try {
                this.callShutdown(ShutdownReason.SERVER_RESOURCES_EXCEEDED);
                this._skeleton = null;
                this._orb.adapterManager().removeRegistrar(this);
                this._connection.sendClose();
            }
            catch (SystemException systemException) {
            }
            java.lang.Object var2_1 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var2_2 = null;
            try {
                this._connection.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            this._connection.close();
        }
        catch (Exception exception) {}
    }

    public String toString() {
        return "GiopProtocolAdapter[connection=" + this._connection + "," + super.toString() + "]";
    }
}

